import es, playerlib, gamethread, popuplib

admins = ['STEAM_ID_LAN', 'YOUR STEAMID HERE', 'Another...', 'AND SO ON']
# to add more, make sure that it is enclosed by '' and seperated from the next by a ,

info = es.AddonInfo()
info.name     = "Warmod"
info.version  = "2.8.4"
info.url      = "http://addons.eventscripts.com/addons/view/warmod"
info.basename = "warmod"
info.author   = "Impact | Master"
es.ServerVar('warmod_ver', info.version, 'Warmod, by Impact | Master').makepublic()

war = {
'active': 0,
'team1': 0,
'score1': 0,
'team2': 0,
'score2': 0,
'swap': 0,
'roundno': 0,
'overtime': 0,
'ot_count': 0,
'players': 0,
'ready': 0,
'mode': 'norm'
}

ready = popuplib.create("ready")

def load():
    es.regcmd('war', 'warmod/start', 'Start a war')
    es.regcmd('war_cancel', 'warmod/war_cancel', 'Cancel war')
    es.regcmd('war_force', 'warmod/war_force', 'Force a war to resume or start (instead of .r)')
    es.regsaycmd('!score', 'warmod/say_score', 'Get the current score')
    es.regsaycmd('!result', 'warmod/show_results', 'See the last wars result!')
    es.regsaycmd('.r', 'warmod/i_ready', 'Mark yourself as ready')
    es.regsaycmd('/r', 'warmod/i_ready', 'Mark yourself as ready')
    es.regsaycmd('/info', 'warmod/s_info', 'resend info popup')
    es.regsaycmd('.info', 'warmod/s_info', 'resend info popup')
    es.regsaycmd('!info', 'warmod/s_info', 'resend info popup')
    es.regsaycmd('.ur', 'warmod/i_unready', 'Mark yourself as unready')
    es.regsaycmd('/ur', 'warmod/i_unready', 'Mark yourself as unready')
    ## Client commmands
    es.regclientcmd('war', 'warmod/c_start', 'Start a war')
    es.regclientcmd('war_cancel', 'warmod/c_war_cancel', 'Cancel war')
    es.regclientcmd('war_force', 'warmod/c_war_force', 'Force a war to resume or start (instead of .r)')
    msg(info.version + " Loaded")
    
def start():
    global war
    es.keygroupdelete("dotr")
    war = {
    'active': 0,
    'team1': 0,
    'score1': 0,
    'team2': 0,
    'score2': 0,
    'swap': 0,
    'roundno': 0,
    'overtime': 0,
    'ot_count': 0,
    'players': 0,
    'ready': 0,
    'mode': 'norm'
    }
    war['team1'] = es.getargv(1)
    war['team2'] = es.getargv(2)
    msg("Starting war between %s and %s" %(war['team1'], war['team2']))
    msg("Everything is automatic -- Including team change")
    dot_r()
    
        
def round_end(event_var):
    global war
    if war['active'] == 1:
    
        war['roundno'] += 1

        
        if war['roundno'] <=15:
            #Team 1 are T's      
            if event_var['winner'] == "2":
                war['score1'] += 1
            elif event_var['winner'] == "3":
                war['score2'] += 1
        else:
            #team 1 are CT's
            if event_var['winner'] == "2":
                war['score2'] += 1
            elif event_var['winner'] == "3":
                war['score1'] += 1
    
        do_score()
        if war['roundno'] == 15:
            if war['swap'] == 0:
                msg("End of section 1")
                gamethread.delayed(1, swap_teams)
                dot_r()
                war['active'] = 0
    
        if war['score1'] == 16:
            msg("End of war - %s wins!" %(war['team1']))
            msg("Final Score was %s - %s" %(war['score1'], war['score2']))
            save_results(1)
            war['active'] = 0
        elif war['score2'] == 16:
            msg("End of war - %s wins!" %(war['team2']))
            msg("Final Score was %s - %s" %(war['score2'], war['score1']))
            save_results(2)
            war['active'] = 0
            
        if war['score1'] == 15 & war['score2'] == 15:
            msg("15 -15 lock!")
            msg("War is going into OVERTIME")
            war['ot_count'] = int(war['ot_count']) + 1
            war['active'] = 0
            war['swap'] = 0
            war['overtime'] = 0
            war['score1'] = 0
            war['score2'] = 0
            war['roundno'] = 0
            war['mode'] = 'ot'
            dot_r()
            
    elif war['overtime'] == 1:
        ##overtime_re()
        war['roundno'] += 1
        
        if war['roundno'] <=3:
            if event_var['winner'] == "2":
                war['score2'] += 1
            elif event_var['winner'] == "3":
                war['score1'] += 1
        else: 
            if event_var['winner'] == "2":
                war['score1'] += 1
            elif event_var['winner'] == "3":
                war['score2'] += 1
        do_score()
        if war['roundno'] == 3:
            if war['swap'] == 0:
                gamethread.delayed(1, ot_swap_teams)
                dot_r()
                war['overtime'] = 0
                war['active'] = 0
    
        if war['score1'] == 4:
                msg("End of war - %s wins!" %(war['team1']))
                msg("Overtime score was %s - %s" %(war['score1'], war['score2']))
                save_results(1)
                war['overtime'] = 0
        elif war['score2'] == 4:
                msg("End of war - %s wins!" %(war['team2']))
                msg("Overtime score was %s - %s" %(war['score2'], war['score1']))
                save_results(2)
                war['overtime'] = 0
    
        if war['score1'] == 3 & war['score2'] == 3:
            msg("3 - 3 lock!")
            war['ot_count'] += 1
            msg("War is going into %sxOVERTIME" %(war['ot_count']))
            war['active'] = 0
            war['swap'] = 0
            war['overtime'] = 0
            war['score1'] = 0
            war['score2'] = 0
            war['roundno'] = 0
            war['mode'] = 'ot'
            dot_r()
            ####################################
def do_lo3():
    global war
    for i in range(0, 6):
          gamethread.delayed(3, msg, "Live on 3 restarts")
    gamethread.delayed(4, es.server.cmd, "mp_restartgame 1")
    for i in range(0, 6):
          gamethread.delayed(5, msg, "Live on 2 restarts")
    gamethread.delayed(6, es.server.cmd, "mp_restartgame 1")
    for i in range(0, 6):
          gamethread.delayed(7, msg, "Live Next Restart!!!")
    gamethread.delayed(8, es.server.cmd, "mp_restartgame 1")
    
    gamethread.delayed(11.7, activate)
    
    gamethread.delayed(9, msg, "*LIVE*------")
    gamethread.delayed(9.1, msg, "-*LIVE*-----")
    gamethread.delayed(9.2, msg, "--*LIVE*----")
    gamethread.delayed(9.3, msg, "---*LIVE*---")
    gamethread.delayed(9.4, msg, "----*LIVE*--")
    gamethread.delayed(9.5, msg, "-----*LIVE*-")
    gamethread.delayed(9.6, msg, "------*LIVE*")
    gamethread.delayed(9.7, msg, "-----*LIVE*-")
    gamethread.delayed(9.8, msg, "----*LIVE*--")
    gamethread.delayed(9.9, msg, "---*LIVE*---")
    gamethread.delayed(10, msg, "--*LIVE*----")
    gamethread.delayed(10.1, msg, "-*LIVE*-----")
    gamethread.delayed(10.2, msg, "*LIVE*------")
    gamethread.delayed(10.3, msg, "*LIVE*------")
    gamethread.delayed(10.4, msg, "-*LIVE*-----")
    gamethread.delayed(10.5, msg, "--*LIVE*----")
    gamethread.delayed(10.6, msg, "---*LIVE*---")
    gamethread.delayed(10.7, msg, "----*LIVE*--")
    gamethread.delayed(10.8, msg, "-----*LIVE*-")
    gamethread.delayed(10.9, msg, "------*LIVE*")
    gamethread.delayed(11, msg, "-----*LIVE*-")
    gamethread.delayed(11.1, msg, "----*LIVE*--")
    gamethread.delayed(11.2, msg, "---*LIVE*---")
    gamethread.delayed(11.3, msg, "---*LIVE*---")
    gamethread.delayed(11.4, msg, "---*LIVE*---")
    gamethread.delayed(11.5, msg, "---*LIVE*---")
    gamethread.delayed(11.5, msg, "---*LIVE*---")
    gamethread.delayed(11.6, msg, "Good Luck! Have Fun!")
        
def swap_teams():
    global war
    war['swap'] = 1
    msg("Swapping teams...")
    ctlist = playerlib.getPlayerList('#ct')
    tlist = playerlib.getPlayerList('#t')
    for player in ctlist:
        es.changeteam(player.userid, '2')
    for player in tlist:
        es.changeteam(player.userid, '3')
    #####################################################
    
def round_start(event_var):
    global war
    if war['active'] == 1:
        pList = playerlib.getPlayerList('#ct')
        for player in pList:
            cash = es.getplayerprop(player.userid, "CCSPlayer.m_iAccount")
            name = es.getplayername(player.userid)
            for tm in pList:
                es.tell(tm.userid, "#multi", "#green [$$] #default %s #green >> #lightgreen $%s" %(name, cash))
        pList = playerlib.getPlayerList('#t')
        for player in pList:
            cash = es.getplayerprop(player.userid, "CCSPlayer.m_iAccount")
            name = es.getplayername(player.userid)
            for tm in pList:
                es.tell(tm.userid, "#multi", "#green [$$] #default %s #green >> #lightgreen $%s" %(name, cash))
        pList = None
    
 
def do_score():
    global war
    if war['score1'] > war['score2']:
        msg("End of round %s -- %s leads %s - %s" %(war['roundno'], war['team1'], war['score1'], war['score2']))
    elif war['score1'] < war['score2']:
        msg("End of round %s -- %s leads %s - %s" %(war['roundno'], war['team2'], war['score2'], war['score1']))
    elif war['score1'] == war['score2']:
        msg("End of round %s -- Game is tied %s all" %(war['roundno'], war['score2']))

def activate():
    global war
    war['active'] = 1
    
def war_cancel():
    global war
    war = {
    'active': 0,
    'team1': 0,
    'score1': 0,
    'team2': 0,
    'score2': 0,
    'swap': 0,
    'roundno': 0
    }
    msg("War has been ended by admin")
        
def do_ot_lo3():
    global war
    for i in range(0, 6):
          gamethread.delayed(3, msg, "Overtime in 3 restarts")
    gamethread.delayed(4, es.server.cmd, "mp_restartgame 1")
    for i in range(0, 6):
          gamethread.delayed(5, msg, "Overtime in 2 restarts")
    gamethread.delayed(6, es.server.cmd, "mp_restartgame 1")
    for i in range(0, 6):
          gamethread.delayed(7, msg, "Overtime Next Restart!!!")
    gamethread.delayed(8, es.server.cmd, "mp_restartgame 1")
    
    gamethread.delayed(11.7, overtime_start)
    gamethread.delayed(9.1, give_cash)
    
    gamethread.delayed(9, msg, "*!OT!*------")
    gamethread.delayed(9.1, msg, "-*!OT!*-----")
    gamethread.delayed(9.2, msg, "--*!OT!*----")
    gamethread.delayed(9.3, msg, "---*!OT!*---")
    gamethread.delayed(9.4, msg, "----*!OT!*--")
    gamethread.delayed(9.5, msg, "-----*!OT!*-")
    gamethread.delayed(9.6, msg, "------*!OT!*")
    gamethread.delayed(9.7, msg, "-----*!OT!*-")
    gamethread.delayed(9.8, msg, "----*!OT!*--")
    gamethread.delayed(9.9, msg, "---*!OT!*---")
    gamethread.delayed(10, msg, "--*!OT!*----")
    gamethread.delayed(10.1, msg, "-*!OT!*-----")
    gamethread.delayed(10.2, msg, "*!OT!*------")
    gamethread.delayed(10.3, msg, "*!OT!*------")
    gamethread.delayed(10.4, msg, "-*!OT!*-----")
    gamethread.delayed(10.5, msg, "--*!OT!*----")
    gamethread.delayed(10.6, msg, "---*!OT!*---")
    gamethread.delayed(10.7, msg, "----*!OT!*--")
    gamethread.delayed(10.8, msg, "-----*!OT!*-")
    gamethread.delayed(10.9, msg, "------*!OT!*")
    gamethread.delayed(11.9, give_cash)
    gamethread.delayed(11, msg, "-----*!OT!*-")
    gamethread.delayed(11.1, msg, "----*!OT!*--")
    gamethread.delayed(11.2, msg, "---*!OT!*---")
    gamethread.delayed(11.3, msg, "---*!OT!*---")
    gamethread.delayed(11.4, msg, "---*!OT!*---")
    gamethread.delayed(11.5, msg, "---*!OT!*---")
    gamethread.delayed(11.5,  msg, "---*!OT!*---")
    gamethread.delayed(11.6, msg, "Good Luck! Have Fun!")
    
def overtime_start():
    global war
    war['overtime'] = 1


def ot_swap_teams():
    global war
    war['swap'] = 1
    war['mode'] = "ot"
    msg("Swapping teams...")
    ctlist = playerlib.getPlayerList('#ct')
    tlist = playerlib.getPlayerList('#t')
    for player in ctlist:
        es.changeteam(player.userid, '2')
    for player in tlist:
        es.changeteam(player.userid, '3')
    dot_r()

def say_score():
    global war
    if war['active'] == 1:
        userid = es.getcmduserid()
        if war['score1'] > war['score2']:
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen %s leads %s - %s" %(war['team1'], war['score1'], war['score2']))
        elif war['score1'] < war['score2']:
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen %s leads %s - %s" %(war['team2'], war['score2'], war['score1']))
        elif war['score1'] == war['score2']:
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen Tie! %s all" %(war['score1']))
    elif war['overtime'] == 1:
        userid = es.getcmduserid()
        if war['score1'] > war['score2']:
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen %s leads %s - %s" %(war['team1'], war['score1'], war['score2']))
        elif war['score1'] < war['score2']:
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen %s leads %s - %s" %(war['team2'], war['score2'], war['score1']))
        elif war['score1'] == war['score2']:
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen Tie! %s all" %(war['score1']))
    else:
        es.tell(userid, "#multi", "#green [Warmod] #lightgreen There is no active war!")

def save_results(winner):
    es.keygroupload("result", "|warmod")
    if winner == 1:
        es.keysetvalue("result", "1", "winner", war['team1'])
        es.keysetvalue("result", "1", "looser", war['team2'])
        es.keysetvalue("result", "1", "wscore", war['score1'])
        es.keysetvalue("result", "1", "lscore", war['score2'])
    elif winner == 2:
        es.keysetvalue("result", "1", "winner", war['team2'])
        es.keysetvalue("result", "1", "looser", war['team1'])
        es.keysetvalue("result", "1", "wscore", war['score2'])
        es.keysetvalue("result", "1", "lscore", war['score1'])
    es.keygroupsave("result", "|warmod")
    es.keygroupdelete("result")
    
def show_results():
    userid = es.getcmduserid()
    es.keygroupload("result", "|warmod")
    es.tell(userid, "#multi", "#green [Warmod] #default In the last war, #lightgreen %s #default beat #lightgreen %s #default %s - %s." %(es.keygetvalue("result","1","winner"),es.keygetvalue("result","1","looser"),es.keygetvalue("result","1","wscore"),es.keygetvalue("result","1","lscore")))
    es.keygroupdelete("result")
    
def give_cash():
    for i in playerlib.getUseridList('#all'):
        es.server.cmd('playerset cash %s 10000'%i)
        
def dot_r():
    global ready
    global war
    war['ready'] = 1
    war['players'] = 0
    es.keygroupcreate("dotr")
    ready.delete()
    ready = popuplib.create("ready")
    ready.addline("     WARMOD - GET READY!")
    ready.addline("------------------------------")
    ready.addline("to make yourself as ready, say")
    ready.addline("     .r      OR       /r")
    ready.addline("------------------------------")
    line = 6
    plist = playerlib.getPlayerList('#ct')
    for i in plist:
        name = es.getplayername(i.userid)
        steam = es.getplayersteamid(i.userid)
        es.keycreate("dotr", steam)
        es.keysetvalue("dotr", steam, "ready", 0)
        es.keysetvalue("dotr", steam, "line", line)
        pnum = line - 5
        ready.addline("->%s - %s -- Not Ready" %(pnum, name))
        line += 1   
        war['players'] = int(war['players']) + 1
    plist = playerlib.getPlayerList('#t')
    for i in plist:
        name = es.getplayername(i.userid)
        steam = es.getplayersteamid(i.userid)
        es.keycreate("dotr", steam)
        es.keysetvalue("dotr", steam, "ready", 0)
        es.keysetvalue("dotr", steam, "line", line)
        pnum = line - 5
        ready.addline("->%s - %s -- Not Ready" %(pnum, name))
        line += 1   
        war['players'] = int(war['players']) + 1
    plist = playerlib.getPlayerList('#all')
    for i in plist:
        ready.send(i.userid)
    
def i_ready():
    global war
    global ready
    if war['ready'] == 1:
        userid = es.getcmduserid()
        steam = es.getplayersteamid(userid)
        name = es.getplayername(userid)
        if int(es.keygetvalue("dotr", steam, "ready")) == 0:
            es.keysetvalue("dotr", steam, "ready", 1)
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen You have been marked as ready")
            line = int(es.keygetvalue("dotr", steam, "line"))
            ready.modline(line, "%s -- Ready!"%(name))
            plist = playerlib.getPlayerList('#all')
            for i in plist:
                ready.update(i.userid)
            war['players'] -= 1
        if war['players'] == 0:
            es.msg("#multi", "#green [Warmod] #lightgreen Everyone is ready! Starting!")
            for i in plist:
                ready.unsend(i.userid)
            if war['mode'] == "norm":
                do_lo3()
            elif war['mode'] == "ot":
                do_ot_lo3()
    else:
        userid = es.getcmduserid()
        es.tell(userid, "#multi", "#green [Warmod] #lightgreen There is no active war!")
            
def war_force():
    global ready
    userid = es.getcmduserid()
    cmd = es.getargv(1)
    plist = playerlib.getPlayerList('#all')
    if cmd == "norm":
        es.msg("#multi", "#green [Warmod] #lightgreen War is being forced to resume!")
        for i in plist:
            ready.unsend(i.userid)
        do_lo3()
    elif cmd == "ot":
        es.msg("#multi", "#green [Warmod] #lightgreen War is being forced to resume!")
        for i in plist:
            ready.unsend(i.userid)
        do_ot_lo3()
    else:
        es.tell(userid, "#multi", "#green [Warmod] #lightgreen Unknow Subcommand, use 'norm' or 'ot'")

def s_info():
    global ready
    userid = es.getcmduserid()
    ready.unsend(userid)
    ready.send(userid)
    
def i_unready():
    global war
    global ready
    if war['ready'] == 1:
        userid = es.getcmduserid()
        steam = es.getplayersteamid(userid)
        name = es.getplayername(userid)
        if int(es.keygetvalue("dotr", steam, "ready")) == 1:
            es.keysetvalue("dotr", steam, "ready", 0)
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen You have been marked as unready")
            line = int(es.keygetvalue("dotr", steam, "line"))
            pnum = line - 5
            ready.modline(line, "->%s - %s -- Not Ready" %(pnum, name))
            plist = playerlib.getPlayerList('#all')
            for i in plist:
                ready.update(i.userid)
            war['players'] += 1


    else:
        userid = es.getcmduserid()
        es.tell(userid, "#multi", "#green [Warmod] #lightgreen There is no active war!")
        
def get_auth(userid):
    global admins
    steam = es.getplayersteamid(userid)
    if steam in admins:
        return True
    else:
        return False
        
def c_start():
    userid = es.getcmduserid()
    admin = get_auth(userid)
    if admin:
        global war
        es.keygroupdelete("dotr")
        war = {
        'active': 0,
        'team1': 0,
        'score1': 0,
        'team2': 0,
        'score2': 0,
        'swap': 0,
        'roundno': 0,
        'overtime': 0,
        'ot_count': 0,
        'players': 0,
        'ready': 0,
        'mode': 'norm'
        }
        war['team1'] = es.getargv(1)
        war['team2'] = es.getargv(2)
        es.msg("#multi", "#green [Warmod] #lightgreen Starting war between %s and %s" %(war['team1'], war['team2']))
        es.msg("#multi", "#green [Warmod] #lightgreen Everything is automatic -- Including team change")
        dot_r()
    else:
        es.tell(userid, "#multi", "#green [Warmod] #lightgreen You are not authorised!")
        
def c_war_cancel():
    userid = es.getcmduserid()
    admin = get_auth(userid)
    if admin:
        global war
        war = {
        'active': 0,
        'team1': 0,
        'score1': 0,
        'team2': 0,
        'score2': 0,
        'swap': 0,
        'roundno': 0
        }
        es.msg("#multi", "#green [Warmod] #lightgreen War has been ended by admin")
    else:
        es.tell(userid, "#multi", "#green [Warmod] #lightgreen You are not authorised!")
        
def c_war_force():
    userid = es.getcmduserid()
    admin = get_auth(userid)
    if admin:
        cmd = es.getargv(1)
        plist = playerlib.getPlayerList('#all')
        if cmd == "norm":
            es.msg("#multi", "#green [Warmod] #lightgreen War is being forced to resume!")
            for i in plist:
                ready.unsend(i.userid)
            do_lo3()
        elif cmd == "ot":
            es.msg("#multi", "#green [Warmod] #lightgreen War is being forced to resume!")
            for i in plist:
                ready.unsend(i.userid)
            do_ot_lo3()
        else:
            es.tell(userid, "#multi", "#green [Warmod] #lightgreen Unknow Subcommand, use 'norm' or 'ot'")
    else:
        es.tell(userid, "#multi", "#green [Warmod] #lightgreen You are not authorised!")
        
def msg(text):
    es.msg("#multi", "#green [Warmod] #lightgreen " + text)
    
def bomb_defused(ev):
    userid = ev['userid']
    es.server.cmd('score del %s 1'%userid)
    
def bomb_exploded(ev):
    userid = ev['userid']
    es.server.cmd('score del %s 3'%userid)